
package kom.itbeankit.common.itbeanframe;

import java.awt.*;
import java.net.*;
/**
 * A URLDialog is a dialog that contains a TextField to 
 * get a URL from the user. The handling of this dialog is similar 
 * to the handling of java.awt.FileDialog
 * @see java.awt.FileDialog
 * @author Christian C. Hoffmann & IBM VisualAge for Java
 * @version 1.0 27/05/98
 */
public class URLDialog extends Dialog implements java.awt.event.ActionListener, java.awt.event.WindowListener {
	private Button ivjButton1 = null;
	private Button ivjButton2 = null;
	private TextField ivjTextField1 = null;
	private URL url = null;

/**
 * This constructor creates a URLDialog and positionate it at
 * the left border of the parent frame.
 * @param parent the parent frame
 */
public URLDialog (Frame parent) {
	super(parent,true);
	initialize();
//	move(parent.getLocation().x+10, parent.getLocation().y+100);
}
/**
 * This constructor creates a URLDialog and sets the frames title.
 * @param parent the parent frame
 * @param title the title of the dialog
 */
public URLDialog(Frame parent, String title) {
	this(parent);
	setTitle(title);
}
/**
 * Method to handle events for the ActionListener interface.
 * @param e java.awt.event.ActionEvent
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
public void actionPerformed(java.awt.event.ActionEvent e) {
	// user code begin {1}
	// user code end
	if ((e.getSource() == getButton1()) ) {
		conn1(e);
	}
	if ((e.getSource() == getButton2()) ) {
		conn2(e);
	}
	if ((e.getSource() == getTextField1()) ) {
		conn3(e);
	}
	// user code begin {2}
	// user code end
}

/**
 * This method will be invoked if the Cancel button is pressed.
 */
private void cancelPressed() {
	dispose();
}
/**
 * conn0:  (URLDialog.window.windowClosing(java.awt.event.WindowEvent) --> URLDialog.dispose())
 * @param arg1 java.awt.event.WindowEvent
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void conn0(java.awt.event.WindowEvent arg1) {
	try {
		// user code begin {1}
		// user code end
		cancelPressed();
		// user code begin {2}
		// user code end
	} catch (java.lang.Throwable ivjExc) {
		// user code begin {3}
		// user code end
		handleException(ivjExc);
	}
}

/**
 * conn1:  (Button1.action.actionPerformed(java.awt.event.ActionEvent) --> URLDialog.okPressed()V)
 * @param arg1 java.awt.event.ActionEvent
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void conn1(java.awt.event.ActionEvent arg1) {
	try {
		// user code begin {1}
		// user code end
		this.okPressed();
		// user code begin {2}
		// user code end
	} catch (java.lang.Throwable ivjExc) {
		// user code begin {3}
		// user code end
		handleException(ivjExc);
	}
}

/**
 * conn2:  (Button2.action.actionPerformed(java.awt.event.ActionEvent) --> URLDialog.cancelPressed()V)
 * @param arg1 java.awt.event.ActionEvent
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void conn2(java.awt.event.ActionEvent arg1) {
	try {
		// user code begin {1}
		// user code end
		this.cancelPressed();
		// user code begin {2}
		// user code end
	} catch (java.lang.Throwable ivjExc) {
		// user code begin {3}
		// user code end
		handleException(ivjExc);
	}
}

/**
 * conn3:  (TextField1.action.actionPerformed(java.awt.event.ActionEvent) --> URLDialog.okPressed()V)
 * @param arg1 java.awt.event.ActionEvent
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void conn3(java.awt.event.ActionEvent arg1) {
	try {
		// user code begin {1}
		// user code end
		this.okPressed();
		// user code begin {2}
		// user code end
	} catch (java.lang.Throwable ivjExc) {
		// user code begin {3}
		// user code end
		handleException(ivjExc);
	}
}

/**
 * Return the Button1 property value.
 * @return java.awt.Button
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private Button getButton1() {
	if (ivjButton1 == null) {
		try {
			ivjButton1 = new java.awt.Button();
			ivjButton1.setName("Button1");
			ivjButton1.setBounds(84, 85, 125, 30);
			ivjButton1.setLabel("OK");
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	};
	return ivjButton1;
}

/**
 * Return the Button2 property value.
 * @return java.awt.Button
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private Button getButton2() {
	if (ivjButton2 == null) {
		try {
			ivjButton2 = new java.awt.Button();
			ivjButton2.setName("Button2");
			ivjButton2.setBounds(294, 85, 125, 30);
			ivjButton2.setLabel("Cancel");
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	};
	return ivjButton2;
}

/**
 * Return the TextField1 property value.
 * @return java.awt.TextField
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private TextField getTextField1() {
	if (ivjTextField1 == null) {
		try {
			ivjTextField1 = new java.awt.TextField();
			ivjTextField1.setName("TextField1");
			ivjTextField1.setBackground(java.awt.Color.white);
			ivjTextField1.setBounds(35, 45, 432, 25);
			ivjTextField1.setColumns(100);
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	};
	return ivjTextField1;
}

/**
 * This method returns the URL that was put in.
 * @return java.net.URL the URL
 */
public URL getURL() {
	return this.url;
}
/**
 * Called whenever the part throws an exception.
 * @param exception java.lang.Throwable
 */
private void handleException(Throwable exception) {

	/* Uncomment the following lines to print uncaught exceptions to stdout */
 System.out.println("--------- UNCAUGHT EXCEPTION ---------");
	exception.printStackTrace(System.out);
}

/**
 * Initializes connections
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void initConnections() {
	// user code begin {1}
	// user code end
	this.addWindowListener(this);
	getButton1().addActionListener(this);
	getButton2().addActionListener(this);
	getTextField1().addActionListener(this);
}

/**
 * Initialize class
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void initialize() {
	// user code begin {1}
	// user code end
	setName("URLDialog");
	setName("URLDialog");
	setLayout(null);
	setBackground(java.awt.SystemColor.window);
	this.setSize(503, 137);
	add(getTextField1(), getTextField1().getName());
	add(getButton1(), getButton1().getName());
	add(getButton2(), getButton2().getName());
	initConnections();
	// user code begin {2}
	// user code end
}

/**
 * This method will be invoked if the OK button was pressed.
 */
private void okPressed() {
	try {
		this.url = new URL(this.ivjTextField1.getText());
	} catch (MalformedURLException e) {
		String t = getTitle();
		setTitle("URL malformed");
		try{ Thread.sleep(500); } catch (InterruptedException ie) { }
		setTitle(t);
		return;
	}
	dispose();
	return;		
}
/**
 * This method sets the URL that will be displayed first.
 * @param url java.net.URL
 */
public void setURL(URL url) {
	this.url = url;
	this.ivjTextField1.setText(url.toExternalForm());
}
/**
 * Method to handle events for the WindowListener interface.
 * @param e java.awt.event.WindowEvent
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
public void windowActivated(java.awt.event.WindowEvent e) {
	// user code begin {1}
	// user code end
	// user code begin {2}
	// user code end
}

/**
 * Method to handle events for the WindowListener interface.
 * @param e java.awt.event.WindowEvent
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
public void windowClosed(java.awt.event.WindowEvent e) {
	// user code begin {1}
	// user code end
	// user code begin {2}
	// user code end
}

/**
 * Method to handle events for the WindowListener interface.
 * @param e java.awt.event.WindowEvent
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
public void windowClosing(java.awt.event.WindowEvent e) {
	// user code begin {1}
	// user code end
	if ((e.getSource() == this) ) {
		conn0(e);
	}
	// user code begin {2}
	// user code end
}

/**
 * Method to handle events for the WindowListener interface.
 * @param e java.awt.event.WindowEvent
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
public void windowDeactivated(java.awt.event.WindowEvent e) {
	// user code begin {1}
	// user code end
	// user code begin {2}
	// user code end
}

/**
 * Method to handle events for the WindowListener interface.
 * @param e java.awt.event.WindowEvent
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
public void windowDeiconified(java.awt.event.WindowEvent e) {
	// user code begin {1}
	// user code end
	// user code begin {2}
	// user code end
}

/**
 * Method to handle events for the WindowListener interface.
 * @param e java.awt.event.WindowEvent
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
public void windowIconified(java.awt.event.WindowEvent e) {
	// user code begin {1}
	// user code end
	// user code begin {2}
	// user code end
}

/**
 * Method to handle events for the WindowListener interface.
 * @param e java.awt.event.WindowEvent
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
public void windowOpened(java.awt.event.WindowEvent e) {
	// user code begin {1}
	// user code end
	// user code begin {2}
	// user code end
}

}